# 画面設計書 10-現在のユーザー情報（Who Am I）

## 概要

本ドキュメントは、Jenkinsの現在のユーザー情報（Who Am I）画面の設計仕様を定義するものです。

### 本画面の処理概要

現在のユーザー情報（Who Am I）画面は、現在ログインしているユーザーの認証情報と権限、およびHTTPリクエストヘッダーを表示するデバッグ/診断用の画面です。

**業務上の目的・背景**：認証や認可に関する問題のトラブルシューティングにおいて、現在のユーザーがどのような認証状態にあるか、どのような権限（GrantedAuthority）を持っているかを確認する必要があります。この画面は、認証の問題解決やセキュリティ監査に役立つ情報を提供します。

**画面へのアクセス方法**：URLで直接 `/whoAmI` にアクセスします。この画面はUnprotectedRootActionとして実装されているため、認証なしでもアクセス可能です（ただし、表示される情報は現在の認証状態に依存します）。

**主要な操作・処理内容**：
1. 現在の認証ユーザー名の表示
2. 認証状態（認証済みかどうか）の表示
3. 付与されている権限（Authorities）の一覧表示
4. HTTPリクエストヘッダーの表示（セキュリティ上危険なヘッダーは除外）

**画面遷移**：Jenkins管理画面やサイドパネルからリンクでアクセスできます。この画面からの特定の遷移先はありません。

**権限による表示制御**：Jenkins.READ権限がある場合はサイドパネルが表示されます。表示される情報は現在の認証コンテキストに基づくため、匿名ユーザーと認証済みユーザーでは異なる情報が表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 30 | ユーザー管理 | 主機能 | ログインユーザー情報の表示 |
| 31 | 権限管理 | 補助機能 | ユーザー権限の表示 |

## 画面種別

詳細（デバッグ/診断）

## URL/ルーティング

- `/whoAmI` - Who Am I画面
- `/whoAmI/api/json` または `/whoAmI/api/xml` - REST API

## 入出力項目

本画面は表示専用であり、入力項目はありません。

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| タイトル | Text | "Who Am I?" |
| Name | String | 現在のユーザー名 |
| IsAuthenticated? | Boolean | 認証済みかどうか |
| Authorities | List&lt;String&gt; | 付与されている権限の一覧 |
| Request Headers | Table | HTTPリクエストヘッダーの一覧 |

## イベント仕様

### （イベントなし）

本画面は情報表示のみであり、ユーザー操作に応じたイベントはありません。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | - | - | データベース更新なし |

### テーブル別更新項目詳細

本画面での直接的なファイルシステム更新はありません。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| (redacted for security reasons) | 情報 | "(redacted for security reasons)" | セキュリティ上危険なヘッダーの値 |

## 例外処理

| 例外状態 | 処理内容 |
|---------|---------|
| null権限 | "null"と表示 |

## 備考

- この画面はUnprotectedRootActionとして実装されており、認証なしでアクセス可能です
- REST APIを通じてJSON/XML形式で情報を取得できます（@ExportedBean）
- セキュリティ上危険なHTTPヘッダー（Cookie、Authorization、Proxy-Authentication等）は内容が隠されます
- サイドパネルはJenkins.READ権限がある場合のみ表示されます

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

認証情報の構造を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | WhoAmI.java | `core/src/main/java/hudson/security/WhoAmI.java` | 画面のバックエンドクラス、@ExportedBeanアノテーション |

**読解のコツ**: WhoAmI.javaはUnprotectedRootActionを実装しており、/whoAmIというURLで直接アクセスできます。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.jelly | `core/src/main/resources/hudson/security/WhoAmI/index.jelly` | 画面のメインテンプレート |

**主要処理フロー**:
1. **29行目**: レイアウト開始（タイトル: "Who Am I"）
2. **30-32行目**: Jenkins.READ権限がある場合にサイドパネルを表示
3. **34行目**: 認証情報を取得（`${app.authentication}`）
4. **35行目**: タイトル表示
5. **36-64行目**: 認証情報テーブル（Name、IsAuthenticated、Authorities）
6. **66行目**: "Request Headers"セクション
7. **68-94行目**: リクエストヘッダーテーブル
8. **70-77行目**: 危険なヘッダーの場合は内容を隠す

#### Step 3: セキュリティ考慮を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | WhoAmI.java | `core/src/main/java/hudson/security/WhoAmI.java` | dangerousHeadersセット、isHeaderDangerous() |

**主要処理フロー**:
- **31-35行目**: 危険なヘッダー名のセット定義（cookie, authorization, www-authenticate等）
- **83-86行目**: isHeaderDangerousメソッドでヘッダーの安全性を判定

#### Step 4: REST APIを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | WhoAmI.java | `core/src/main/java/hudson/security/WhoAmI.java` | getApi()、@Exportedアノテーション |

**主要処理フロー**:
- getName(), isAuthenticated(), isAnonymous(), getAuthorities() が@Exportedでエクスポート

### プログラム呼び出し階層図

```
/whoAmI (URL)
    │
    └─ WhoAmI (UnprotectedRootAction)
           │
           ├─ index.jelly
           │      │
           │      ├─ [READ権限あり]
           │      │      └─ sidepanel.jelly (Jenkinsサイドパネル)
           │      │
           │      ├─ app.authentication
           │      │      ├─ auth.name
           │      │      ├─ auth.authenticated
           │      │      └─ auth.authorities
           │      │
           │      └─ request2.getHeaderNames()
           │             └─ isHeaderDangerous() で安全性判定
           │
           └─ getApi() → JSON/XML出力
                  ├─ getName()
                  ├─ isAuthenticated()
                  ├─ isAnonymous()
                  └─ getAuthorities()
```

### データフロー図

```
[入力]               [処理]                    [出力]

HTTPリクエスト ───▶ WhoAmI ───▶ Authenticationオブジェクト取得
                       │              │
                       │              ├─ auth.name
                       │              ├─ auth.authenticated
                       │              └─ auth.authorities
                       │
                       └─ リクエストヘッダー取得
                              │
                              └─ isHeaderDangerous()でフィルタリング
                                     │
                                     └─ HTML/JSON/XML出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.jelly | `core/src/main/resources/hudson/security/WhoAmI/index.jelly` | テンプレート | メイン画面テンプレート |
| WhoAmI.java | `core/src/main/java/hudson/security/WhoAmI.java` | ソース | バックエンドクラス、REST API |
| sidepanel.jelly | `core/src/main/resources/jenkins/model/Jenkins/sidepanel.jelly` | テンプレート | Jenkinsサイドパネル |
| Functions.java | `core/src/main/java/hudson/Functions.java` | ソース | getRequestHeaders()ヘルパー |
